<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CarAndDrivingDeleteExistingRule extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'Delete Existing Images if Other Provider Images Exist',
                'config_key' => 'app-content-car-and-driving-should-delete-existing-images',
                'description' => 'If other provider images exist for a vehicle, and if more than the minimum threshold, should all existing Car and Driving images be deleted on import?',
                'type' => 'boolean',
                'value' => false
            ],
        ];
    }
}
