<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SilverBulletStage2SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Show "Build a deal" button',
                'config_key' => 'sales-silver-bullet-build-deal',
                'type' => 'boolean',
                'value' => true,
                'order' => 10,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Build your deal button text',
                'config_key' => 'sales-silver-bullet-deal-button-text',
                'type' => 'string',
                'value' => 'Build your deal',
                'order' => 11,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Show "Reserve for XX" button',
                'config_key' => 'sales-silver-bullet-reserve',
                'type' => 'boolean',
                'value' => true,
                'order' => 12,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Reserve button text',
                'config_key' => 'sales-silver-bullet-reserve-button-text',
                'type' => 'string',
                'value' => 'Reserve for £99',
                'order' => 13,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Show "Trade In" journey button',
                'config_key' => 'sales-silver-bullet-trade-in',
                'type' => 'boolean',
                'value' => false,
                'order' => 14,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Trade-In button text',
                'config_key' => 'sales-silver-bullet-trade-in-button-text',
                'type' => 'string',
                'value' => 'Value my car',
                'order' => 15,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Show "Finance" journey button',
                'config_key' => 'sales-silver-bullet-finance',
                'type' => 'boolean',
                'value' => false,
                'order' => 16,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Finance button text',
                'config_key' => 'sales-silver-bullet-finance-button-text',
                'type' => 'string',
                'value' => 'Apply for finance',
                'order' => 17,
            ],
        ];
    }
}
