<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehiclePreRegSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Vehicle Pre-Reg Condition',
                'config_key' => 'vehicles-pre-reg-condition-enabled',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'standard',
                'description' => 'Enable Pre-Reg Condition for vehicles'
            ],
        ];
    }
}
