<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\CarzoneExportJob;
use App\Jobs\ChannelFeedExportJob;
use App\Jobs\EasiChatExportJob;
use App\Jobs\InventoryExportJob;
use App\Jobs\PhyronExportJob;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class PhyronExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('phyron-export');
        Vehicle::factory(10)->create();

        (new PhyronExportJob())->handle();

        Storage::disk('phyron-export')->assertExists('foo_faz.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'phyron')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
