<?php

namespace App\Console\Commands;

use App\TierHelper;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Mtc\ContentManager\Facades\Media;
use Mtc\MercuryDataModels\Media as MediaModel;

class ClearUnusedMediaFiles extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clear:unused-media';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove old unused media files from system';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $media = MediaModel::query()
            ->where('created_at', '<=', Carbon::now()->subMonths(TierHelper::orphanedMediaAge(tenant('tier'))))
            ->where(fn($query) => $query->whereNull('last_used')
                ->orWhere('last_used', '<=', Carbon::now()->subMonths(TierHelper::orphanedMediaAge(tenant('tier')))))
            ->whereDoesntHave('uses')
            ->pluck('id')
            ->toArray();

        Media::destroyMedia($media);
    }
}
