<?php

namespace App\Contracts;

interface StockProvider
{
    /**
     * Check if stock provider is enabled
     *
     * @return bool
     */
    public function enabled(): bool;

    /**
     * Name of the stock provider
     *
     * @return string
     */
    public function name(): string;

    /**
     * Import vehicle collection from the provider
     *
     */
    public function runScheduledImport(): void;
}
