<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PropertyList extends JsonResource
{
    public static $wrap = '';

    private string $categoryName = '';

    public function setCategoryName(string $name): self
    {
        $this->categoryName = $name;
        return $this;
    }

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $resource = $this->resource->toArray();
        $resource['category'] = $this->categoryName;
        return $resource;
    }
}
