<?php

namespace App\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\VehicleReservations\Reservation;

class ReservationList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource
                ->through(fn(Reservation $reservation) => $this->mapReservation($reservation));
        } else {
            $this->resource = $this->resource
                ->map(fn(Reservation $reservation) => $this->mapReservation($reservation));
            return parent::toArray($request);
        }
        return parent::toArray($request);
    }

    private function mapReservation(Reservation $reservation): array
    {
        return [
            'image' => [
                'src' => $reservation->vehicle?->getPreviewImage('mini-thumb'),
                'alt' => $reservation->vehicle?->title,
            ],
            'active' => true,
            'status' => $reservation->status,
            'title' => $reservation->name,
            'description' => $reservation->vehicle?->title,
            'metaItems' => [
            ],
            'link' => '/reservations/view/' . $reservation->id,
            'id' => $reservation->id,
        ];
    }
}
