<?php

namespace App\Jobs;

use App\Exports\AutowebDealerExport;
use App\Exports\AutowebExport;
use Illuminate\Support\Facades\Storage;
use App\Facades\Settings;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Config;
use Maatwebsite\Excel\Facades\Excel;
use Mtc\MercuryDataModels\SalesChannelHistory;
use PhpParser\Node\Expr\Throw_;

class AutowebExportJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    private string $ftpUsername;
    private string $ftpPassword;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->onQueue('export');
        $this->ftpUsername = Settings::get('sales-channels-autoweb-ftp-username', '');
        $this->ftpPassword = Settings::get('sales-channels-autoweb-ftp-password', '');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            Config::set('filesystems.disks.autoweb-export.username', $this->ftpUsername);
            Config::set('filesystems.disks.autoweb-export.password', $this->ftpPassword);
            $export = new AutowebExport();

            Excel::store(
                $export,
                Settings::get('sales-channels-autoweb-file-name'),
                'autoweb-export'
            );

            SalesChannelHistory::store('autoweb', true, $export->collection()->count() . ' records exported');
        } catch (Exception $exception) {
            SalesChannelHistory::store('autoweb', false, $exception->getMessage());
        }
    }
}
