<?php

namespace App\Jobs;

use App\Facades\Settings;
use App\Services\AutoTraderHub;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\Vehicle;

class ExportVehicleToAutoTrader implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(private readonly Vehicle $vehicle, private readonly AutoTraderHub $service)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->service->setToken(Settings::get('auto-trader-hub-token'))
            ->export($this->vehicle);
    }
}
