<?php

namespace App\Listeners;

use App\Events\NewVehicleImported;
use App\Facades\Settings;
use App\Jobs\FetchAIDescription;
use App\VehicleSpec\Jobs\FetchVehicleSpecData;
use App\VehicleSpec\VehicleSpecServiceHelper;
use Illuminate\Foundation\Bus\DispatchesJobs;

class CreateVehicleAiDescriptionOnNewVehicleImport
{
    use DispatchesJobs;

    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(NewVehicleImported $event): void
    {
        if (Settings::get('open-ai-generate-description-on-vehicle-imported')) {
            $this->dispatch(new FetchAIDescription($event->vehicle));
        }
    }
}
