<?php

namespace App\Traits;

use App\Facades\Settings;

trait GetsColourSettings
{
    protected function getColourSettings()
    {
        $keys = [
            'app-primary-colour',
            'app-secondary-colour',
            'app-tertiary-colour',
            'app-success-colour',
            'app-error-colour',
            'app-information-colour',
            'app-text-colour',
            'app-subtext-colour',
            'app-layer-dark-colour',
            'app-layer-accent-colour',
            'app-layer-light-colour',
        ];

        $colours = [];

        foreach ($keys as $key) {
            $colours[$key] = Settings::get($key);
        }

        return $colours;
    }
}
