<?php

namespace Database\Seeders;

use App\Traits\TrackedSeeding;
use Illuminate\Database\Seeder;
use Mtc\Crm\Seeds\EnquiryStatusSeeder;

class DatabaseSeeder extends Seeder
{
    use TrackedSeeding;

    protected static $seeds = [
        Tenant\BaseSettingSeeder::class,
        Tenant\SeoSettingSeeder::class,
        Tenant\EmailReservationConfirmationContentSeeder::class,
        Tenant\AutomotiveSettingSeeder::class,
        Tenant\FinanceSettingSeeder::class,
        Tenant\EnquiryMaxSettingSeeder::class,
        Tenant\RapidRTCSettingSeeder::class,
        Tenant\VisitorSettingSeeder::class,
        Tenant\ChatSettingSeeder::class,
        Tenant\SilverBulletSettingSeeder::class,
        Tenant\StripeSettingSeeder::class,
        Tenant\AutoImagingSettingSeeder::class,
        Tenant\AutosOnShowSettingSeeder::class,
        Tenant\VehicleSpecSeeder::class,
        Tenant\OpenAISeeder::class,
        Tenant\VehicleSpecMotorCheckSeeder::class,
        Tenant\VehicleFilterSettingSeeder::class,
        Tenant\NewsletterSettingSeeder::class,
        Tenant\CarGuruExportSeeder::class,
        Tenant\CarWowExportSeeder::class,
        Tenant\HeyCarExportSeeder::class,
        Tenant\CarSnipExportSeeder::class,
        Tenant\AaCarsExportSeeder::class,
        Tenant\AlternateOpenThirdTimesSeeder::class,
        Tenant\AutowebExportSeeder::class,
        Tenant\CarsIrelandExportSeeder::class,
        Tenant\PhyronExportSeeder::class,
        Tenant\MotoNovoExportSeeder::class,
        Tenant\MotorsCoUkExportSeeder::class,
        Tenant\EbayMotorsExportSeeder::class,
        Tenant\MotorsSettingSeeder::class,
        Tenant\PinewoodSettingSeeder::class,
        Tenant\DMSNavigatorSettingSeeder::class,
        Tenant\AutoTraderStockSettingSeeder::class,
        Tenant\ChannelFeedExportSeeder::class,
        Tenant\ChannelPagination::class,
        Tenant\SiteAccessPasswordSeed::class,
        Tenant\BrandingSettingSeeder::class,
        Tenant\SeoViewIdSettingSeeder::class,
        Tenant\StockSyncFrequencySeeder::class,
        Tenant\DealershipDefaultTimeSettingSeeder::class,
        Tenant\TimezoneSettingSeeder::class,
        Tenant\TrackingCodeSeeder::class,
        Tenant\LinkedInTrackingSeeder::class,
        Tenant\PageTypeSettingSeeder::class,
        Tenant\PageTypeDefaultTemplateSeed::class,
        Tenant\ImaginStudioSeeder::class,
        Tenant\AdvancedFinanceSettingsSeed::class,
        Tenant\BcaCapValuationSettingSeeder::class,
        Tenant\BeepBeepValuationSettingSeeder::class,
        Tenant\BeepBeepLookupSettingSeeder::class,
        Tenant\ChatSettingSeeder::class,
        Tenant\EasichatSettingSeeder::class,
        Tenant\CalltracksSettingSeeder::class,
        Tenant\CalltracksAlterSettingSeeder::class,
        Tenant\RemoveBgSettingSeeder::class,
        Tenant\OccupopSettingSeeder::class,
        Tenant\LabelsSeeder::class,
        Tenant\LabelJustArrivedSettingSeeder::class,
        Tenant\SimilarVehiclesSettingSeeder::class,
        Tenant\CapLookupSettingSeeder::class,
        Tenant\SkodaSyncTypeSettingSeeder::class,
        Tenant\CapLookupOverrideAttributes::class,
        Tenant\AutoloadItFtpSettingSeeder::class,
        Tenant\CarzoneExportSeeder::class,
        Tenant\OpenAIDescriptionSeeder::class,
        Tenant\AutomotiveLoadMoreSettingSeeder::class,
        Tenant\DealershipsUrlPathSettingSeeder::class,
        Tenant\AutoTraderLookupSettingSeeder::class,
        Tenant\InventoryExportSeeder::class,
        Tenant\ProductsFinanceRiskBasedPricingSettingsSeed::class,
        Tenant\PostcodeMileageFilterSettingSeeder::class,
        Tenant\CarzoneSoldReservedStockSettingSeeder::class,
        Tenant\AutoTraderRemoveImagesSetting::class,
        Tenant\AutoTraderLabelForLCVCarsSetting::class,
        Tenant\AutoTraderRemoveLabelsSetting::class,
        Tenant\SkodaDeliveryPriceSettingSeeder::class,
        Tenant\ImaginStudioZoomLevelSeeder::class,
        Tenant\FilterSelectionsOnResultsForWidgetSeeder::class,
        Tenant\SkupenetNewVehicleStockSettingSeeder::class,
        Tenant\OpenAIPromptSeeder::class,
        Tenant\AutoSetOriginalPriceSeeder::class,

        // Dealerweb CRM endpoint
        Tenant\DealerWebLmsSettingSeeder::class,
        Tenant\DealerWebEndpointSettingSeeder::class,

        // CRM data (forms, enquiry types, statuses)
        EnquiryStatusSeeder::class,
        Tenant\ContactFormSeeder::class,

        // Theme default data
        ThemeContentSeeder::class,
    ];

    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        foreach (self::$seeds as $seeder) {
            $this->trackedSeed($seeder);
        }
    }
}
