<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Models\EnquiryType;
use Mtc\Crm\Models\Form;

class ContactFormSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->enquiryTypes())
            ->each(fn(string $entry) => EnquiryData::addType($entry));

        $this->contactForm();
        $this->offerQuery();
        $this->vehicleQuery();
    }

    private function enquiryTypes(): array
    {
        return [
            'General Contact Enquiry',
            'Vehicle Enquiry',
            'Offer Enquiry',
            'Test Drive',
            'Service',
        ];
    }

    private function contactForm()
    {
        /** @var Form $form */
        $form = Form::query()
            ->create([
                'name' => 'Website Contact Form',
                'type_id' => EnquiryType::query()->where('name', 'General Contact Enquiry')->first()->id ?? 0,
                'is_active' => 1,
                'initial_status_id' => 1,
                'notify_customer_on_received_enquiry' => 1,
                'customer_notification_subject' => 'We have received your enquiry',
                'customer_notification_content' => 'We will reply to your query in a timely manner.',
            ]);

        $section = $form->sections()
            ->create([
                'name' => 'Details',
                'settings' => [
                    'classSuffix' => 'fields'
                ],
                'segments' => [
                    'Header',
                    'Fields',
                    'Actions',
                ],
            ]);

        $form->questions()
            ->create([
                'form_section_id' => $section->id,
                'name' => 'Get in touch today',
                'type' => 'message',
                'segment' => 'Header',
            ]);

        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'First Name',
                'is_enquiry_subject' => 1,
                'type' => 'text_field',
                'order' => 0,
                'data' => [
                    'enquiry-max-field' => 'forename',
                ],
                'validation' => [
                    'required'
                ]
            ]);
        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Last Name',
                'is_enquiry_subject' => 1,
                'type' => 'text_field',
                'order' => 0,
                'data' => [
                    'enquiry-max-field' => 'surname',
                ],
                'validation' => [
                    'required'
                ]
            ]);

        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Your Email',
                'type' => 'email_field',
                'is_customers_email' => 1,
                'order' => 0,
                'data' => [
                    'enquiry-max-field' => 'emailAddress',
                ],
                'validation' => [
                    'required',
                    'email'
                ]
            ]);

        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Your Phone Number',
                'type' => 'text_field',
                'order' => 0,
                'data' => [
                    'enquiry-max-field' => 'mobileTelephoneNumber',
                ],
            ]);

        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Message',
                'type' => 'text_area',
                'order' => 0,
                'data' => [
                    'enquiry-max-field' => 'notes',
                ],
                'validation' => [
                    'required'
                ]
            ]);

        $form->questions()
            ->create([
                'segment' => 'Actions',
                'form_section_id' => $section->id,
                'name' => 'Enquire Now',
                'type' => 'submit_button',
            ]);
    }

    private function offerQuery()
    {
        /** @var Form $form */
        $form = Form::query()
            ->create([
                'name' => 'Offer Enquiry',
                'type_id' => EnquiryType::query()->where('name', 'Offer Enquiry')->first()->id ?? 0,
                'is_active' => 1,
                'initial_status_id' => 1,
                'notify_customer_on_received_enquiry' => 1,
                'customer_notification_subject' => 'We have received your enquiry',
                'customer_notification_content' => 'We will reply to your query in a timely manner.',
            ]);

        $section = $form->sections()
            ->create([
                'name' => 'Details',
                'settings' => [
                    'classSuffix' => 'fields'
                ],
                'segments' => [
                    'Header',
                    'Fields',
                    'Actions',
                ],
            ]);


        $form->questions()
            ->create([
                'segment' => 'Header',
                'form_section_id' => $section->id,
                'name' => 'Get in touch today',
                'type' => 'message',
            ]);


        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Offer ID',
                'is_enquiry_subject' => 1,
                'type' => 'offer_id',
                'order' => 0,
                'validation' => [
                    'required',
                ]
            ]);


        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'First Name',
                'is_enquiry_subject' => 1,
                'type' => 'text_field',
                'order' => 0,
                'validation' => [
                    'required'
                ]
            ]);


        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Surname',
                'is_enquiry_subject' => 1,
                'type' => 'text_field',
                'order' => 1,
                'validation' => [
                    'required'
                ]
            ]);

        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Your Email',
                'type' => 'email_field',
                'is_customers_email' => 1,
                'order' => 2,
                'validation' => [
                    'required',
                    'email'
                ]
            ]);

        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Your Phone Number',
                'type' => 'text_field',
                'order' => 3,
            ]);

        $form->questions()
            ->create([
                'segment' => 'Actions',
                'form_section_id' => $section->id,
                'name' => 'Enquire Now',
                'type' => 'submit_button',
            ]);
    }

    private function vehicleQuery()
    {
        /** @var Form $form */
        $form = Form::query()
            ->create([
                'name' => 'Vehicle Enquiry',
                'type_id' => EnquiryType::query()->where('name', 'Vehicle Enquiry')->first()->id ?? 0,
                'is_active' => 1,
                'initial_status_id' => 1,
                'notify_customer_on_received_enquiry' => 1,
                'customer_notification_subject' => 'We have received your enquiry',
                'customer_notification_content' => 'We will reply to your query in a timely manner.',
            ]);

        $section = $form->sections()
            ->create([
                'name' => 'Details',
                'settings' => [
                    'classSuffix' => 'fields'
                ],
                'segments' => [
                    'Header',
                    'Fields',
                    'Actions',
                ],
            ]);


        $form->questions()
            ->create([
                'segment' => 'Header',
                'form_section_id' => $section->id,
                'name' => 'Get in touch today',
                'type' => 'message',
            ]);

        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Vehicle ID',
                'is_enquiry_subject' => 1,
                'type' => 'vehicle_id',
                'order' => 0,
                'validation' => [
                    'required',
                ]
            ]);


        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'First Name',
                'is_enquiry_subject' => 1,
                'type' => 'text_field',
                'order' => 0,
                'validation' => [
                    'required'
                ]
            ]);


        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Surname',
                'is_enquiry_subject' => 1,
                'type' => 'text_field',
                'order' => 1,
                'validation' => [
                    'required'
                ]
            ]);

        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Your Email',
                'type' => 'email_field',
                'is_customers_email' => 1,
                'order' => 2,
                'validation' => [
                    'required',
                    'email'
                ]
            ]);

        $form->questions()
            ->create([
                'segment' => 'Fields',
                'form_section_id' => $section->id,
                'name' => 'Your Phone Number',
                'type' => 'text_field',
                'order' => 3,
            ]);

        $form->questions()
            ->create([
                'segment' => 'Actions',
                'form_section_id' => $section->id,
                'name' => 'Enquire Now',
                'type' => 'submit_button',
            ]);
    }
}
