<?php

namespace Database\Seeders;

use App\Facades\Settings;
use Database\Seeders\MercuryTheme\ContentElementSeeder;
use Database\Seeders\MercuryTheme\GlobalContentSeeder;
use Database\Seeders\MercuryTheme\MenuSeeder;
use Database\Seeders\MercuryTheme\OfferTypeSeeder;
use Database\Seeders\MercuryTheme\PageSeeder;
use Database\Seeders\MercuryTheme\TemplateSeeder;
use Illuminate\Database\Seeder;
use Mtc\MercuryDemoData\DemoContentSeed;

class ThemeContentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->call(ContentElementSeeder::class);
        $this->call(GlobalContentSeeder::class);
        $this->call(TemplateSeeder::class);
        $this->call(OfferTypeSeeder::class);
        $this->call(PageSeeder::class);
        $this->call(MenuSeeder::class);

        $this->call(DemoContentSeed::class);

        $this->socials();
    }

    protected function socials()
    {
        try {
            Settings::update('app-socials-facebook', 'https://www.facebook.com/mtcmedialtd');
            Settings::update('app-socials-twitter', 'https://twitter.com/mtcmedia');
            Settings::update('app-socials-instagram', 'https://www.instagram.com/mtcmedia/');
            Settings::update('app-socials-linkedin', 'https://www.linkedin.com/company/mtcmedia/');
        } catch (\Exception $exception) {
            dump('unable to seed demo socials');
        }
    }
}
