@extends('crm::emails.layout', [
    'subject' => $enquiry->subject ?? 'New Enquiry',
])

@section('content')

    @php
        // TODO: Pull colour variables from Tenant
        $layerLightColour = '#f2f5f7';
        $layerWhiteColour = '#fff';
        $layerAccentColour = '#D2D2D7';
        $primaryColour = '#269ece';
        $textColour = '#1F2424';

        $innerWrapperWidth = '700';
        $contentWrapperWidth = '600';
    @endphp

    @if(!empty($enquiry->intro))
        <tr>
            <td colspan="2">
                <p>{{ $enquiry->intro }}</p>
            </td>
        <tr>
    @endif

    @foreach($enquiry->details as $entry)
        @if(!empty($entry['answer']))
            <tr>
                <td width="32%" valign="top" style="border-bottom:1px solid {{ $layerAccentColour }};padding: 10px;">
                    <strong>{{ $entry['question'] }}</strong>
                </td>

                <td width="58%" valign="middle"
                    style="border-bottom:1px solid {{ $layerAccentColour }};padding:10px;">
                    @if (!empty($entry['value']))
                        {{ $entry['value'] }}
                    @else
                        {{ is_array($entry['answer']) ? implode(', ', $entry['answer']) : $entry['answer'] }}
                    @endif
                </td>
            </tr>
        @endif
    @endforeach

    @includeIf('emails.enquiry.partials.' . $enquiry->reason_type)

    {{-- TODO: We only want to show the below if admin and not sent to customer --}}
    <tr>
        <td height="20" colspan="2"></td>
    </tr>

    <tr>
        <td align="center" colspan="2">
            <a href="{{ $enquiry->getViewUrl() }}"
               target="_blank"
               rel="noopener noreferrer"
               style="width:300px; max-width:100%; display:inline-block; text-align:center; text-decoration:none; color:{{ $layerWhiteColour }}; background-color:{{ $primaryColour }}; padding:12px 0; border-radius:5px;"
            >
                View Details in CRM
            </a>
        </td>
    </tr>

    <tr>
        <td height="20" colspan="2"></td>
    </tr>
@endsection
