<?php

namespace Tests\Feature;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Crm\Facades\Enquiries;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\MercuryDataModels\Property;
use Mtc\MercuryDataModels\PropertyCategory;
use Tests\TestCase;
use Tests\UserForTenant;

class EnquiryRepositoryTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testShowList()
    {
        Enquiry::factory(10)->create();
        $list = Enquiries::showList(\request());
        $this->assertInstanceOf(LengthAwarePaginator::class, $list);
        $this->assertEquals(10, $list->total());
    }


    public function testShowEditUrl()
    {
        $enquiry = \Mtc\Crm\Models\Enquiry::factory()->create([
            'title' => 'foo',
            'reason_type' => 'vehicle',
            'reason_id' => 123
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->get(route('enquiries.details', $enquiry->id));
        $this->assertStringContainsString('vehicles', $response->json('reason_url'));

        $enquiry = \Mtc\Crm\Models\Enquiry::factory()->create([
            'title' => 'foo',
            'reason_type' => 'new-car',
            'reason_id' => 123
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->get(route('enquiries.details', $enquiry->id));
        $this->assertStringContainsString('new-vehicles', $response->json('reason_url'));

        $enquiry = \Mtc\Crm\Models\Enquiry::factory()->create([
            'title' => 'foo',
            'reason_type' => 'offer',
            'reason_id' => 123
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->get(route('enquiries.details', $enquiry->id));
        $this->assertStringContainsString('offers', $response->json('reason_url'));

        $enquiry = \Mtc\Crm\Models\Enquiry::factory()->create([
            'title' => 'foo',
            'reason_type' => 'valuation',
            'reason_id' => 123
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->get(route('enquiries.details', $enquiry->id));
        $this->assertStringContainsString('valuations', $response->json('reason_url'));

        $category = PropertyCategory::factory()->create(['slug' => 'foo']);
        $property = Property::factory()->create(['slug' => 'baz', 'category_id' => $category->id]);

        $enquiry = \Mtc\Crm\Models\Enquiry::factory()->create([
            'title' => 'foo',
            'reason_type' => 'property',
            'reason_id' => $property->id
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->get(route('enquiries.details', $enquiry->id));
        $this->assertStringContainsString('properties/foo/edit/' .$property->id, $response->json('reason_url'));
    }
}
