<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Jobs\HeyCarExportJob;
use App\Modules\SalesChannels\HeyCar;
use Database\Seeders\Tenant\HeyCarExportSeeder;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;

class HeyCarExportTest extends TestCase
{
    use DatabaseMigrations;

    protected $tenancy = true;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('hey-car-export');
        $this->seed(HeyCarExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-hey-car-file-name', 'foo.csv');

        $this->dispatch(new HeyCarExportJob());

        Storage::disk('hey-car-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'hey-car')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }

    public function testSalesChannelClass()
    {
        Storage::fake('hey-car-export');
        $this->seed(HeyCarExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-hey-car-file-name', 'foo.csv');
        Settings::update('sales-channels-hey-car-enabled', true);

        app(HeyCar::class)->runScheduledExport();

        Storage::disk('hey-car-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'hey-car')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
