<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\MercuryDataModels\Menu;
use Mtc\MercuryDataModels\MenuEntry;
use Mtc\MercuryDataModels\Page;
use Tests\TestCase;

class MenuEntryTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testAddPageMenuEntry()
    {
        $page = Page::factory()->create([
            'title' => 'foo',
            'slug' => 'test',
        ]);

        /** @var Menu $menu */
        $menu = Menu::factory()->create();
        /** @var MenuEntry $entry */
        $entry = $menu->entries()
            ->create([
                'name' => 'foo',
                'url' => '/baz',
                'item_id' => $page->id,
                'item_type' => 'page',
            ]);

        $this->assertEquals('/test', $entry->url);
    }

    public function testChangePageMenuEntry()
    {
        $page = Page::factory()->create([
            'title' => 'foo',
            'slug' => 'test',
        ]);

        /** @var Menu $menu */
        $menu = Menu::factory()->create();
        /** @var MenuEntry $entry */
        $entry = $menu->entries()
            ->create([
                'name' => 'foo',
                'url' => '/baz',
            ]);

        $this->assertEquals('/baz', $entry->url);

        $entry->update([
            'item_id' => $page->id,
            'item_type' => 'page',
        ]);

        $this->assertEquals('/test', $entry->url);
    }

    public function testUpdatePageMenuEntry()
    {
        $page = Page::factory()->create([
            'title' => 'foo',
            'slug' => 'test',
        ]);

        /** @var Menu $menu */
        $menu = Menu::factory()->create();
        /** @var MenuEntry $entry */
        $entry = $menu->entries()
            ->create([
                'name' => 'foo',
                'url' => '/baz',
                'item_id' => $page->id,
                'item_type' => $page->getMorphClass(),
            ]);

        $this->assertEquals('/test', $entry->url);

        $page->update([
            'slug' => 'foo-baz-bar'
        ]);

        $entry->refresh();
        $this->assertEquals('/foo-baz-bar', $entry->url);
    }
}
