<?php

namespace Tests\Unit;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\ContentManager\Models\ContentElement;
use Mtc\ContentManager\Models\ContentElementField;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\MercuryDataModels\VehicleOffer;
use Mtc\MercuryDataModels\VehicleOfferContent;
use Tests\TestCase;

class VehicleOfferTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testSearchContentSetWhenSaving()
    {
        $make = VehicleMake::factory()->create(['name' => 'bmw']);
        $model = VehicleModel::factory()->create(['name' => '330i']);
        $vehicle = VehicleOffer::factory()->create([
            'make_id' => $make->id,
            'model_id' => $model->id,
            'derivative' => 'e92 Petrol Coupe',
        ]);

        $element = ContentElement::factory()->create();
        $field = ContentElementField::factory()->create([
            'element_id' => $element->id,
            'field_type' => 'textarea',
        ]);

        VehicleOfferContent::factory()->create([
            'offer_id' => $vehicle->id,
            'parent_id' => null,
            'element_id' => $element->id,
            'content' => [
                $field->name => 'foo baz bar'
            ]
        ]);

        // Manually touch vehicle to update search content.
        // In controller this is done by updating offer after content
        $vehicle->touch();

        $this->assertStringContainsString('bmw', $vehicle->search_content);
        $this->assertStringContainsString('330i', $vehicle->search_content);
        $this->assertStringContainsString('e92', $vehicle->search_content);
        $this->assertStringContainsString('foo', $vehicle->search_content);
        $this->assertStringContainsString('baz', $vehicle->search_content);
    }
}
