# Mercury Admin/Backend API module

## About Project

This app is a Laravel based api for handling admin user functionality on content
management platforms. Its base is to provide a SaaS framework that can be easily 
used as a base for different type of systems/industries.

## Installation & Setup

The installation guidelines are for LOCAL development environment.

### Pre-requisites 
Docker is required to run this application locally. If you do not have docker set up 
follow the below guides to set it up on your environment.

[On Windows it is recommended to use WSL2](https://docs.microsoft.com/en-us/windows/wsl/install-win10)

[Getting Started with Docker](https://www.docker.com/get-started)

Local environment will require php8.0 or higher for installation.

On Linux/Windows WSL php8.1 can be installed via following commands:
```bash
sudo apt update
sudo apt install lsb-release ca-certificates apt-transport-https software-properties-common -y
sudo add-apt-repository ppa:ondrej/php
sudo apt install php8.1 php8.1-dom php8.1-curl php8.1-mbstring
```

### Step 1
```bash
git clone git@bitbucket.org:mtcmedia/mercury-backend-api.git PROJECT_PATH

cd PROJECT_PATH
composer install --ignore-platform-reqs
cp .env.example .env
```

### Step 2
Spin up docker environment
```bash
vendor/bin/sail up -d
```

### Step 3
Prepare application

```bash
sail artisan key:generate
sail artisan local:install
```

> Note that `sail` is only accessible as an alias or file is added to global path. You will need to run `vendor/bin/sail`
> if you do not have it available. It can be set up by adding `alias sail='[ -f sail ] && bash sail || bash vendor/bin/sail'`
> to your bash profile file (`~/.bashrc` or `~/.zshrc` depending on which shell are you using).
> Once you have added this line (at the end of file) run `source ~/.zshrc` (or `source ~/.bashrc`)
> to apply shell or close/open terminal.


### Step 4
Switch over to your work branch and start working on your application work. API will be available at
[http://localhost](http://localhost). If you require additional 
domains these can be managed in the OS hosts file

To execute commands for your application (e.g. artisan, composer etc.) 
you need to call `vendor/bin/sail` binary. Please read through 
[Sail documentation](https://laravel.com/docs/8.x/sail) for actions.
It is also recommended setting up the sail alias for simplifying the calls 
on frequent use.

Access to database can be done via clients like Sequel Pro, HeidiSQL and others with given config:
```
Hostname: 127.0.0.1
User: root
Password:
```

Emails can be accessed via Mailhog - [http://localhost:8025](http://localhost:8025) 

## Documentation


[Front-end Authentication](docs/auth.md) 



## API Docs

API docs are auto-generated to a swagger.json file with the following package:

```shell
autonomy artisan laravel-swagger:generate --format=yaml -f '/api' -o public/vendor/swagger/swagger.yaml
```

This command automatically creates a file that describes the API.
Documentation will be viewable on the given url: `/docs/swagger`of the project.
php yaml module is required for this (not installed by default on Laravel Sail).

When generating documentation we filter `/api` path as all routes should go through
this path as part of authentication middleware process. Only known (allowed) exceptions
are `/sanctum/csrf-token` which is used for system to generate csrf token and 
debug tools like `/telescope`
