<?php

namespace App\Actions\IntegrationVerification;

use App\VehicleSpec\Services\Cap;
use App\VehicleType;
use Mtc\MercuryDataModels\Vehicle;

class VerifyCapSpecs
{
    public function __construct(private readonly Cap $cap)
    {
    }

    public function verify(): bool
    {
        $vehicle = new Vehicle([
            'cap_id' => 83772,
            'registration_number' => 'KN23 XMD',
            'type' => VehicleType::CAR->value,
        ]);


        return $this->cap->getSpec($vehicle)->technical_data !== null;
    }
}
