<?php

declare(strict_types=1);

namespace App\Http\Middleware;

use Closure;

class InitializeTenancyByDomainInRequest extends InitializeTenancyByDomain
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        self::$onFail = fn($e) => response($request->input('tenant') . ' Not Found', 404);

        return $this->initializeTenancy(
            $request,
            $next,
            str_replace('www.', '', $request->input('tenant') ?? '')
        );
    }
}
