<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\ContentManager\Models\Media;

class BulkDeleteCarAndDrivingImages extends Command
{
    protected $signature = 'car-and-driving:bulk-delete-images';
    protected $description = 'Delete all images imported from Car and Driving';

    public function handle()
    {
        Media::where('image_provider', 'car-and-driving')
            ->chunkById(100, function ($mediaItems) {
                foreach ($mediaItems as $mediaItem) {
                    $mediaItem->uses()->delete();
                    $mediaItem->delete();
                }
            });

        $this->info('Car and Driving images deleted successfully.');

        return Command::SUCCESS;
    }
}
