<?php

namespace App\Crm;

use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\Crm\Models\FormQuestion;

trait EnquiryDataToProviderData
{
    private function convertEnquiryToParams(EnquiryModel $enquiry, string $provider): array
    {
        $answers = collect($enquiry->details ?? [])->map(fn($answer) => $answer['answer'] ?? null);
        return FormQuestion::query()
            ->whereIn('id', $answers->keys())
            ->get()
            ->keyBy('id')
            ->map(fn($question) => $question->data[$provider] ?? null)
            ->filter()
            ->flip()
            ->map(fn($id, $key) => $answers[$id] ?? null)
            ->toArray();
    }
}
