# Front-end Authentication

### Login

`POST /api/login`
```json
{
    "email": "john@example.com",
    "password": "securePassword2"
}
```
Responses:

200 - OK
```json
{"two_factor":false}
```

422 - Unprocessable Entity
```json
{"message":"The given data was invalid.","errors":{"email":["These credentials do not match our records."]}}
```

___

### Logout

`POST /api/login`
Responses:

204 - No Content

___
### Forgot Password

`POST /api/login`
```json
{
    "email": "john@example.com",
}
```
Responses:

200 - OK 

```json
{"message":"We have emailed your password reset link!"}
```
* Will trigger email notification.

422 - Unprocessable Entity
```json
{"message":"The given data was invalid.","errors":{"email":["The email field is required."]}}
```


___
### Reset Password

`POST /api/reset-password`
```json
{
    "email": "john@example.com",
    "token": "PASSWORD_RESET_TOKEN",
    "password": "securePassword2",
    "password_confirmation": "securePassword2"
}
```
Responses:

200 - OK

```json
{"message":"Your password has been reset!"}
```

422 - Unprocessable Entity
```json
{"message":"The given data was invalid.","errors":{"email":["This password reset token is invalid."]}}
```

___
### Update profile information

`PUT api/user/profile-information`
```json
{
    "name" : "John Doe",
    "email": "john@example.com"
}
```
