<?php

namespace Database\Seeders\MercuryTheme;

use App\Master\Models\VehicleMake;
use Illuminate\Database\Seeder;
use Mtc\ContentManager\Models\ContentElement;
use Mtc\ContentManager\Models\MenuEntry;
use Mtc\MercuryDataModels\Menu;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Menu::query()->truncate();
        MenuEntry::query()->truncate();
        collect($this->getList())
            ->each(function ($entry) {
                /** @var Menu $menu */
                $menu = Menu::query()->create($entry);
                $this->recursiveEntryAdd($menu, $entry['children'] ?? []);
            });
    }

    private function recursiveEntryAdd(Menu $menu, array $entries = [], ?MenuEntry $parent = null)
    {
        if (empty($entries)) {
            return;
        }

        foreach ($entries as $entry) {
            $data = [
                'menu_id' => $menu->id,
                'element_id' => is_null($parent) ? $menu->first_child_element_id : null,
                'is_enabled' => true,
                'content' => $entry['content'] ?? null,
                'name' => $entry['name'],
                'url' => $entry['url'] ?? null,
            ];

            /** @var MenuEntry $newEntry */
            $newEntry = $parent
                ? $parent->children()->create($data)
                : MenuEntry::query()->create($data);

            $this->recursiveEntryAdd($menu, $entry['children'] ?? [], $newEntry);
        }
    }

    private function getList()
    {
        return [
            [
                'title' => 'Header Center',
                'slug' => 'header-main',
                'first_child_element_id' => ContentElement::query()->where('slug', 'menu')->first()?->id,
                'children' => [
                    [
                        'name' => 'Find a vehicle',
                        'url' => '/catalog/',
                        'content' => [
                            'type' => 'menu',
                            'data' => [
                                'image' => '/images/menuBanner.webp',
                                'text' => 'View all cars in stock',
                                'link' => '/catalog/',
                                'action_text' => 'View new 72 plate offers >',
                                'action_link' => '/offers/',
                            ]
                        ],
                        'children' => [
                            [
                                'name' => 'Used Cars',
                                'children' => [
                                    [
                                        'name' => 'Audi',
                                        'url' => '/catalog/audi',
                                        'item_type' => 'vehicles',
                                        'data' => [
                                            'make_id' => VehicleMake::query()->where('name', 'Audi')->first()?->id
                                        ]
                                    ],
                                    [
                                        'name' => 'BMW',
                                        'url' => '/catalog/bmw',
                                        'item_type' => 'vehicles',
                                        'data' => [
                                            'make_id' => VehicleMake::query()->where('name', 'BMW')->first()?->id
                                        ]
                                    ],
                                    [
                                        'name' => 'Jaguar',
                                        'url' => '/catalog/jaguar',
                                        'item_type' => 'vehicles',
                                        'data' => [
                                            'make_id' => VehicleMake::query()->where('name', 'Jaguar')->first()?->id
                                        ]
                                    ],
                                    [
                                        'name' => 'Land Rover',
                                        'url' => '/catalog/land-rover',
                                        'item_type' => 'vehicles',
                                        'data' => [
                                            'make_id' => VehicleMake::query()->where('name', 'Land Rover')->first()?->id
                                        ]
                                    ],
                                    [
                                        'name' => 'Porsche',
                                        'url' => '/catalog/porsche',
                                        'item_type' => 'vehicles',
                                        'data' => [
                                            'make_id' => VehicleMake::query()->where('name', 'Porsche')->first()?->id
                                        ]
                                    ],
                                    [
                                        'name' => 'Volkswagen',
                                        'url' => '/catalog/volkswagen',
                                        'item_type' => 'vehicles',
                                        'data' => [
                                            'make_id' => VehicleMake::query()->where('name', 'Volkswagen')->first()?->id
                                        ]
                                    ],
                                ]
                            ],
                            [
                                'name' => 'New Cars',
                                'url' => '/offers',
                                'children' => [
                                    [
                                        'name' => 'BMW',
                                        'url' => '/offers/bmw',
                                        'item_type' => 'offers',
                                        'data' => [
                                            'make_id' => VehicleMake::query()->where('name', 'BMW')->first()?->id
                                        ]
                                    ],
                                    [
                                        'name' => 'Jaguar',
                                        'url' => '/offers/jaguar',
                                        'item_type' => 'offers',
                                        'data' => [
                                            'make_id' => VehicleMake::query()->where('name', 'Jaguar')->first()?->id
                                        ]
                                    ],
                                ]
                            ],
                        ]
                    ],
                    [
                        'name' => 'Sell',
                    ],
                    [
                        'name' => 'Service',
                        'url' => '/services',
                    ],
                    [
                        'name' => 'Electric',
                    ],
                    [
                        'name' => 'Motability',
                    ],
                ],
            ],
            [
                'title' => 'Header Sidebar',
                'slug' => 'header-sidebar',
            ],
            [
                'title' => 'Footer',
                'slug' => 'footer',
                'children' => [
                    [
                        'name' => 'Mercury',
                        'children' => [
                            [
                                'name' => 'Contact us',
                                'url' => '/contact-us',
                            ],
                            [
                                'name' => 'Locations',
                                'url' => '/locations',
                            ],
                            [
                                'name' => 'About us',
                                'url' => '/about-us',
                            ],
                            [
                                'name' => 'Careers',
                                'url' => '/careers',
                            ],
                            [
                                'name' => 'News',
                                'url' => '/news',
                            ],
                            [
                                'name' => 'Motability',
                                'url' => '/motability',
                            ],
                            [
                                'name' => 'Electric',
                                'url' => '/electric',
                            ],
                        ]
                    ],
                    [
                        'name' => 'The legal bit',
                        'children' => [
                            [
                                'name' => 'Terms & conditions',
                                'url' => '/terms-and-conditions',
                            ],
                            [
                                'name' => 'Privacy notice',
                                'url' => '/privacy-notice',
                            ],
                        ],
                    ],
                    [
                        'name' => 'Product & Services',
                        'children' => [
                            [
                                'name' => 'Car valuations',
                                'url' => '/terms-and-conditions',
                            ],
                            [
                                'name' => 'Vehicle check',
                                'url' => '/vehicle-check',
                            ],
                            [
                                'name' => 'Sell my car',
                                'url' => '/sell-my-car',
                            ],
                            [
                                'name' => 'Service & MOT',
                                'url' => '/service-and-mot',
                            ],
                            [
                                'name' => 'Part exchange',
                                'url' => '/part-exchange',
                            ],
                            [
                                'name' => 'Finance Calculator',
                                'url' => '/finance-calculator',
                            ],
                        ],
                    ],
                    [
                        'name' => 'Quick Search',
                        'children' => [
                            [
                                'name' => 'All makes and models',
                                'url' => '/catalog/',
                            ],
                            [
                                'name' => 'New Car Offers',
                                'url' => '/offers/',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }
}
