<?php

namespace App\Http\Controllers;

use App\Http\Resources\GlobalContentResource;
use App\Http\Resources\PageResource;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Session;
use Mtc\ContentManager\Models\Page;
use Mtc\MercuryDataModels\GlobalContent;

class PageController extends Controller
{
    /**
     * Show page detail
     *
     * @param Request $request
     * @param string $pageSlug
     * @return PageResource|Response
     */
    public function show(Request $request, string $pageSlug): PageResource|Response
    {
        // Not using binding in route as to allow for Seo Redirect middleware
        $page = Page::query()->where('slug', $pageSlug)->active()->firstOrFail();
        if ($this->restrictedPage($page, $request->input())) {
            return response('Access denied', 401);
        }
        return new PageResource($page);
    }

    public function globalContent($slug)
    {
        return Cache::remember(tenant('id') . "-global-content-$slug", $this->cacheLife(), function () use ($slug) {
            return new GlobalContentResource(GlobalContent::query()
                ->where('slug', $slug)
                ->firstOrFail());
        });
    }

    private function cacheLife(): Carbon
    {
        return Carbon::now()->addMinutes(app()->environment('production') ? 60 : 0);
    }

    private function restrictedPage(Page $page, array $input): bool
    {
        if (empty($page->password)) {
            return false;
        }

        $submitted_password = $input['password'] ?? Session::get('page-auth-password');
        if ($submitted_password === $page->password) {
            Session::put('page-auth-password', $submitted_password);
        }

        return $submitted_password !== $page->password;
    }
}
