<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PropertyEntry extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->makeHidden([
            'id',
            'active',
            'created_at',
            'updated_at',
            'category_id',
            'attribute_values',
        ]);

        collect($this->resource->attributeValues)
            ->each(fn($attribute) => $this->resource[$attribute->slug] = $attribute->getValue());

        return parent::toArray($request);
    }
}
