<?php

namespace App\Http\Resources;

use App\Facades\Feature;
use App\Facades\Settings;
use App\Modules\PlaceholderImages\ImaginStudio;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\App;

class ValuationResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $image = null;
        if (
            Feature::isEnabled('imagin-studio-placeholders')
            && Settings::get('imagin-placeholders-valuation-lookup-enabled')
        ) {
            $image = App::make(ImaginStudio::class)->getForOther(
                $this->resource->make,
                $this->resource->model,
                $this->resource->colour
            );
        }
        return [
            'id' => $this->resource->id,
            'make' => $this->resource->make,
            'model' => $this->resource->model,
            'image' => $image,
            'registration' => $this->resource->registration,
            'mileage' => $this->resource->mileage,
            'derivative' => $this->resource->derivative,
            'fuelType' => $this->resource->fuel_type,
            'bodyType' => $this->resource->body_type,
            'retailPrice' => $this->resource->retail_price,
            'belowPrice' => $this->resource->below_price,
            'averagePrice' => $this->resource->average_price,
            'cleanPrice' => $this->resource->clean_price,
        ];
    }
}
