<?php

namespace App\Http\Resources;

use App\OfferRepository;
use App\Traits\HasPlaceholderImage;
use App\Traits\RetrievesContent;
use Illuminate\Http\Resources\Json\JsonResource;

class OfferResource extends JsonResource
{
    use HasPlaceholderImage;
    use FranchiseData;
    use PhoneNumberDisplay;
    use RetrievesContent;

    public static $wrap = '';

    private const UI_RESOURCE_PREFIX = 'App\\Http\\Resources\\';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load([
            'mediaUses.media',
            'finance',
            'transmission',
            'fuelType',
            'bodyStyle',
            'drivetrain',
            'specs',
            'features',
            'equipment',
            'form.sections.questions',
            'content.mediaUses.media',
            'content.subContent.mediaUses.media',
            'content.subContent.subContent.mediaUses.media',
            'content.subContent.subContent.subContent.mediaUses.media',
            'content.contentElement',
            'content.globalContent.contentElement',
            'content.subContent.contentElement',
            'content.subContent.globalContent.contentElement',
            'content.subContent.subContent.contentElement',
            'content.subContent.subContent.globalContent.contentElement',
            'content.subContent.subContent.subContent.contentElement',
            'content.subContent.subContent.subContent.globalContent.contentElement',
        ]);

        $this->resource->make_name = $this->resource->make?->name;
        $this->resource->model_name = $this->resource->model?->name;
        $this->resource->view_stock = false;

        $this->resource->forms = [
            'enquire' => $this->resource->form
                ? (new FormViewResource($this->resource->form))->setValues([ 'offer_id' => $this->resource->id ])
                : null,
        ];

        $this->resource->features = $this->resource->features->pluck('name');

        $resource = $this->resource->only([
            'name',
            'price',
            'deposit',
            'make_name',
            'model_name',
            'derivative',
            'content',
            'media_uses',
            'forms',
            'finance',
        ]);

        $resource['media_uses'] = $this->getGallery($this->resource);
        $resource['details'] = $this->getDetails();

        $resource['cross_sell'] = (new OfferRepository())->similar($this->resource);
        $resource['contact_number'] = $this->getContactNumber();
        $resource['content'] = $this->getContent($this->resource->content);
        $resource['seo'] = $this->fillSeo('offer');
        $resource['isFranchise'] = $this->isFranchise();
        $resource['franchise'] = $this->franchiseData();
        $resource['specs'] = $this->resource->specs
            ->map(fn($entry) => $entry->only(['description', 'category', 'value']));
        $resource['features'] = $this->resource->features;
        $resource['equipment'] = $this->resource->equipment
            ->map(fn($entry) => $entry->only(['type', 'code', 'description', 'category', 'price']));
        return $resource;
    }

    private function getDetails(): array
    {
        return [
            [
                'name' => __('labels.vehicle.colour'),
                'value' => $this->resource->colour
            ],
            [
                'name' => __('labels.vehicle.engine_size'),
                'value' => $this->resource->engine_size_cc ? $this->resource->engine_size_cc . 'cc' : null,
            ],
            [
                'name' => __('labels.vehicle.fuel_type'),
                'value' => $this->resource->fuelType?->name
            ],
            [
                'name' => __('labels.vehicle.body_style'),
                'value' => $this->resource->bodyStyle?->name
            ],
            [
                'name' => __('labels.vehicle.transmission'),
                'value' => $this->resource->transmission?->name
            ],
            [
                'name' => __('labels.vehicle.drivetrain'),
                'value' => $this->resource->drivetrain?->name
            ],
        ];
    }

    protected function largeImageDimensions(): string
    {
        return 'large';
    }

    protected function mediumImageDimensions(): string
    {
        return 'medium';
    }

    protected function thumbnailImageDimensions(): string
    {
        return 'medium';
    }
}
