<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Overload migrations/routes
    |--------------------------------------------------------------------------
    |
    | Allows disabling default migration/route workflows to set up custom ones
    |
    */
    'load_routes' => false,
    'load_migrations' => false,

    /*
    |--------------------------------------------------------------------------
    | Filter Instance
    |--------------------------------------------------------------------------
    |
    | This class will be used to perform filtering in system. It has been
    | so it can be changed, but necessity for it should be small
    | as all aspects like filters, object being filtered, sorting and other
    | elements can be managed through other config options
    |
    */
    'filter_instance' => \App\Filter::class,

    /*
    |--------------------------------------------------------------------------
    | Filters
    |--------------------------------------------------------------------------
    |
    | These are the filters that will be passed down to site. Each filter
    | carries out actions for applying selections, fetching filter choices
    | and other aspects to ensure easy integration in the system. Filter
    | needs to be an instance/extension of IsFilter class.
    | When generating URL filters will be sorted in order listed how they are
    | ordered here (e.g. category/brand/size or /category/category/size)
    |
    */
    'filters' => [
        'make' => \Mtc\MercuryDataModels\Filters\MakeFilter::class,
        'model' => \Mtc\MercuryDataModels\Filters\ModelFilter::class,
        'body_type' => \Mtc\MercuryDataModels\Filters\BodyTypeFilter::class,
        //'price' => \Mtc\MercuryDataModels\Filters\PriceFilter::class,
        'price_max' => \Mtc\MercuryDataModels\Filters\PriceMaxFilter::class,
        'price_min' => \Mtc\MercuryDataModels\Filters\PriceMinFilter::class,
        'age' => \Mtc\MercuryDataModels\Filters\AgeFilter::class,
        'age-range' => \Mtc\MercuryDataModels\Filters\AgeRangeFilter::class,
        'consumption' => \Mtc\MercuryDataModels\Filters\ConsumptionFilter::class,
        'colour' => \Mtc\MercuryDataModels\Filters\ColourFilter::class,
        //'door_count' => \Mtc\MercuryDataModels\Filters\DoorFilter::class,
        //'engine_size' => \Mtc\MercuryDataModels\Filters\EngineSizeFilter::class,
        'doors_min' => \Mtc\MercuryDataModels\Filters\DoorMinFilter::class,
        'doors_max' => \Mtc\MercuryDataModels\Filters\DoorMaxFilter::class,
        'engine_size_min' => \Mtc\MercuryDataModels\Filters\EngineSizeMinFilter::class,
        'engine_size_max' => \Mtc\MercuryDataModels\Filters\EngineSizeMaxFilter::class,
        'fuel_type' => \Mtc\MercuryDataModels\Filters\FuelTypeFilter::class,
        'transmission' => \Mtc\MercuryDataModels\Filters\TransmissionFilter::class,
        'location' => \Mtc\MercuryDataModels\Filters\LocationFilter::class,
        'manufacture_year_min' => \Mtc\MercuryDataModels\Filters\ManufactureYearMinFilter::class,
        'manufacture_year_max' => \Mtc\MercuryDataModels\Filters\ManufactureYearMaxFilter::class,
        //'mileage' => \Mtc\MercuryDataModels\Filters\MileageFilter::class,
        'mileage_min' => \Mtc\MercuryDataModels\Filters\MileageMinFilter::class,
        'mileage_max' => \Mtc\MercuryDataModels\Filters\MileageMaxFilter::class,
        //'seats' => \Mtc\MercuryDataModels\Filters\SeatFilter::class,
        'seats_max' => \Mtc\MercuryDataModels\Filters\SeatMaxFilter::class,
        'seats_min' => \Mtc\MercuryDataModels\Filters\SeatMinFilter::class,
        'co2' => \Mtc\MercuryDataModels\Filters\CO2Filter::class,
        'insurance-group' => \Mtc\MercuryDataModels\Filters\InsuranceGroupFilter::class,
        'postcode' => \Mtc\MercuryDataModels\Filters\PostcodeFilter::class,
        'search' => \Mtc\MercuryDataModels\Filters\SearchTermFilter::class,
        'price_point' => \Mtc\MercuryDataModels\Filters\PricePointFilter::class,
        'vehicle_type' => \Mtc\MercuryDataModels\Filters\VehicleTypeFilter::class,
        'vehicle_category' => \Mtc\MercuryDataModels\Filters\VehicleCategoryFilter::class,
        'franchise' => \Mtc\MercuryDataModels\Filters\FranchiseFilter::class,
        'is_new' => \Mtc\MercuryDataModels\Filters\IsNewFilter::class,
        'stock_status' => \Mtc\MercuryDataModels\Filters\StockStatusFilter::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Filtered Object Class
    |--------------------------------------------------------------------------
    |
    | This is the class that specifies how the filtered object (Product)
    | should be filtered and how to format its results.
    |
    */
    'filter_object' => \App\VehicleFilter::class,

    /*
    |--------------------------------------------------------------------------
    | Result Sorting
    |--------------------------------------------------------------------------
    |
    | Sort options available on site. Each class specifies how to order
    | results for the constructed query.
    |
    */

    'sort_options' => [
        'latest' => \Mtc\Filter\Sorting\NewArrivals::class,
        'price-desc' => \App\Filter\Sorting\PriceDescending::class,
        'price-asc' => \App\Filter\Sorting\PriceAscending::class,
        'monthly-price-desc' => \App\Filter\Sorting\MonthlyPriceDescending::class,
        'monthly-price-asc' => \App\Filter\Sorting\MonthlyPriceAscending::class,
        'mileage-desc' => \App\Filter\Sorting\MileageDescending::class,
        'mileage-asc' => \App\Filter\Sorting\MileageAscending::class,
        'age-desc' => \App\Filter\Sorting\AgeDescending::class,
        'age-asc' => \App\Filter\Sorting\AgeAscending::class,
    ],
];
