<?php

namespace App\Http\Resources;

use App\Traits\RetrievesContent;
use Illuminate\Http\Resources\Json\JsonResource;

class GlobalContentResource extends JsonResource
{
    use RetrievesContent;

    public static $wrap = '';

    public function toArray($request): array
    {
        $this->resource->load('mediaUses.media');
        $resource = $this->resource->toArray();

        $resource['content'] = $this->getContent(collect($this->resource->subContent));

        return $resource;
    }
}
