<?php

namespace App\Http\Resources;

use App\Traits\MediaHasSizes;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Form;
use Mtc\MercuryDataModels\MediaUse;
use Mtc\MercuryDataModels\PropertyAttributeValue;

class PropertyEntry extends JsonResource
{
    use MediaHasSizes;

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->makeHidden([
            'id',
            'active',
            'created_at',
            'updated_at',
            'category_id',
            'attribute_values',
        ]);

        collect($this->resource->attributeValues)
            ->each(fn($attribute) => $this->resource[$attribute->slug] = $this->getAttributeValue($attribute));

        return parent::toArray($request);
    }

    private function getAttributeValue(PropertyAttributeValue $attribute): mixed
    {
        if ($attribute->type == 'form-field') {
            return (new FormViewResource(Form::query()->find($attribute->getValue())))
                ->setValues(['property_id' => $this->resource->id]);
        }
        if ($attribute->type == 'image') {
            return MediaUse::query()
                ->whereIn('media_id', $attribute->getValue())
                ->with('media')
                ->get()
                ->map(fn($mediaUse) => [
                    'src' => $mediaUse->getUrl('square-tile'),
                    'sizes' => $this->allSizesForUse($this->resource, $mediaUse),
                    'alt' => $mediaUse->alt_text,
                    'caption' => $mediaUse->caption,
                    'title' => $mediaUse->title,
                ]);
        }
        return $attribute->getValue();
    }
}
