<?php

namespace App\Tracking;

use App\Facades\Settings;
use Illuminate\Contracts\Support\Arrayable;

class HotJarTracking implements Arrayable
{
    public function toArray()
    {
        $code = Settings::get('tracking-hotjar-code');
        return [
            [
                "body" => '(function(h,o,t,j,a,r){'
                    . 'h.hj=h.hj||function(){(h.hj.q=h.hj.q||[]).push(arguments)};'
                    . 'h._hjSettings={hjid:' . $code . ',hjsv:6};'
                    . 'a=o.getElementsByTagName(‘head’)[0];'
                    . 'r=o.createElement(‘script’);r.async=1;'
                    . 'r.src=t+h._hjSettings.hjid+j+h._hjSettings.hjsv;'
                    . 'a.appendChild(r);'
                    . '})(window,document,‘https://static.hotjar.com/c/hotjar-','.js?sv=’);',
                'data-consent' => 'analytical'
            ]
        ];
    }
}
