<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Models\MediaSize;

trait MediaHasSizes
{
    private function allSizesForUse(Model $model, MediaUse $mediaUse, string $owner_type_override = ''): Collection
    {
        $owner_type = !empty($owner_type_override) ? $owner_type_override : $mediaUse->getOwnerType();

        $this->mediaSizes = Cache::remember(
            tenant('id') . '-media-sizes-' . $mediaUse->getOwnerType(),
            now()->addHour(),
            fn() => MediaSize::query()->where('model', $owner_type)->get()
        );

        return $this->mediaSizes
            ->keyBy('label')
            ->map(fn(MediaSize $size) => $mediaUse->getUrl($size->label));
    }
}
