<?php

namespace App\Http\Controllers;

use App\Http\Requests\ValuationRequest;
use App\Http\Resources\PageResource;
use App\Http\Resources\ValuationResource;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Models\Page;
use Mtc\VehicleValuation\Facades\Valuation;

class ValuationController extends Controller
{
    public function show(): PageResource|Response
    {
        if (!Valuation::hasEnabledDriver()) {
            return response('Valuations not available', 404);
        }

        $page = Page::query()->where('slug', 'valuation')->active()->firstOrFail();
        return new PageResource($page);
    }

    public function get(ValuationRequest $request): ValuationResource
    {
        if (Valuation::hasMultiStep() && !$request->filled('variant_id')) {
            return new ValuationResource(Valuation::getVehicleVariants(
                $request->input('registration_number'),
                $request->input('mileage')
            ));
        }
        $valuation = Valuation::get(
            $request->input('registration_number'),
            $request->input('mileage'),
            $request->input('variant_id')
        );
        return new ValuationResource($valuation);
    }
}
