<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\CatalogOffer;

trait RetrievesCatalogOffers
{
    /**
     * @return bool
     */
    protected function hasCatalogOffers(): bool
    {
        return CatalogOffer::query()
            ->active()
            ->exists();
    }

    /**
     * @return Model|Builder|null
     */
    protected function getCatalogOffer(): Model|Builder|null
    {
        return CatalogOffer::query()
            ->inRandomOrder()
            ->first();
    }
}
