<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class FormViewResource extends JsonResource
{
    private array $assignedValues = [];

    public function setValues(array $values)
    {
        $this->assignedValues = $values;
        return $this;
    }

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        if (!$this->resource) {
            return [];
        }

        return [
            'id' => $this->resource->id,
            'title' => $this->resource->form_title,
            'success_message' => $this->resource->success_message,
            'button_text' => $this->resource->button_text,
            'sections' => $this->resource->sections->map(fn($section) => [
                'name' => $section->name,
                'settings' => $section->settings ?? [],
                'segments' => collect($section->segments ?? [])
                    ->map(fn($segment) => [
                        'name' => $segment,
                        'questions' => $section->questions
                            ->where('segment', $segment)
                            ->map(fn($question) => [
                                'id' => $question->id,
                                'type' => $this->questionType($question->type),
                                'name' => $question->name,
                                'value' => $this->assignedValues[$question->type] ?? null,
                                'choices' => $this->questionChoices($question),
                                'placeholder' => $question->placeholder,
                                'description' => $question->description,
                            ]),
                    ]),
            ]),
        ];
    }

    private function questionType(string $fieldType): string
    {
        return match ($fieldType) {
            'offer_id', 'page_id', 'vehicle_id', 'valuation_id' => 'hidden',
            default => $fieldType,
        };
    }

    private function questionChoices(object $question): array|null
    {
        return $question->data['meta']['options']['items'] ?? null;
    }
}
