<?php

namespace App\Http\Resources\VehicleAction;

use App\Facades\Settings;
use App\Sales\SilverBullet;
use App\Tier;
use App\TierHelper;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\VehicleValuation\Facades\Valuation;

class ValuationFactory
{
    public function get(Vehicle $vehicle)
    {
        if ($this->hasKeyloopValuation()) {
            return App::make(SilverBullet::class)->getVehicleAction($vehicle, 'valuation');
        }

        if ($this->hasWebValuation()) {
            return $this->webValuation();
        }

        return false;
    }

    private function hasKeyloopValuation(): bool
    {
        return Settings::get('sales-silver-bullet-enabled')
            && Settings::get('sales-silver-bullet-trade-in');
    }

    private function webValuation()
    {
        return [
            'type' => 'url',
            'title' => 'Value my car',
            'value' => '/valuation',
        ];
    }

    private function hasWebValuation()
    {
        return TierHelper::isAllowed(tenant('tier'), Tier::PRO->value)
            && Valuation::hasEnabledDriver();
    }
}
