<?php

return [
    'repository' => \App\ValuationRepository::class,
    /*
    |--------------------------------------------------------------------------
    |  Drivers
    |--------------------------------------------------------------------------
    |
    | Drivers that provide valuation functionality
    |
    */
    'drivers' => [
        'cap' => [
            'config' => \App\Modules\Valuation\Config\CapConfig::class,
            'class' => \Mtc\VehicleValuation\CapData::class,
        ],
        'auto-trader' => [
            'config' => \App\Modules\Valuation\Config\AutoTrader::class,
            'class' => \Mtc\VehicleValuation\AutoTrader::class,
            'api_key' => env('AUTO_TRADER_API_KEY'),
            'api_secret' => env('AUTO_TRADER_API_SECRET'),
            'merchant_id' => env('AUTO_TRADER_API_MERCHANT_ID'),
            'live' => env('AUTO_TRADER_USE_LIVE_API', true),
        ],
        'bca' => [
            'config' => \App\Modules\Valuation\Config\BCAConfig::class,
            'class' => \Mtc\VehicleValuation\BCA::class,
            'api_key' => env('BCA_API_KEY'),
            'api_secret' => env('BCA_API_SECRET'),
            'live' => env('BCA_LIVE_API', true),
        ],
        'motor-check' => [
            'config' => \App\Modules\Valuation\Config\MotorCheck::class,
            'class' => \Mtc\VehicleValuation\MotorCheck::class,
        ],
        'beepbeep' => [
            'config' => \App\Modules\Valuation\Config\BeepBeepConfig::class,
            'class' => \Mtc\VehicleValuation\BeepBeep::class,
            'api_key' => env('BEEP_BEEP_API_KEY')
        ]
    ],
];
