<?php

namespace App\Http\Controllers;

use App\Http\Requests\ValuationRequest;
use App\Http\Resources\PageResource;
use App\Http\Resources\ValuationResource;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;
use Mtc\ContentManager\Models\Page;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\VehicleValuation\Facades\Valuation;
use Illuminate\Http\Request;

class ValuationController extends Controller
{
    public function show(Request $request): PageResource|Response
    {
        if (!Valuation::hasEnabledDriver()) {
            return response('Valuations not available', 404);
        }

        $page = Page::query()
            ->where('slug', $request->input('slug', 'valuation'))
            ->active()
            ->firstOrFail();

        return new PageResource($page);
    }

    public function get(ValuationRequest $request): Response|ValuationResource
    {
        $exists_on_site = Vehicle::query()
            ->where('vrm_condensed', str_replace(' ', '', $request->input('registration_number')))
            ->exists();

        if ($exists_on_site) {
            throw ValidationException::withMessages(['Valuation not possible for this vehicle']);
        }

        try {
            if (Valuation::hasMultiStep() && !$request->filled('variant_id')) {
                return new ValuationResource(Valuation::getVehicleVariants(
                    $request->input('registration_number'),
                    $request->input('mileage')
                ));
            }
            $valuation = Valuation::get(
                $request->input('registration_number'),
                $request->input('mileage'),
                $request->input('variant_id')
            );
            return new ValuationResource($valuation);
        } catch (\Exception $exception) {
            Log::error('Valuation: ' . $exception->getMessage());

            return response([
                'success' => false,
                'message' => $exception->getMessage(),
            ], 422);
        }
    }
}
