<?php

namespace App\Http\Controllers;

use App\Http\Requests\ViewVehicleRequest;
use App\Http\Resources\VehicleResource;
use App\VehicleRepository;
use Mtc\MercuryDataModels\Vehicle;
use App\Repositories\RecentlyViewed;
use Illuminate\Http\Request;

class VehicleController extends Controller
{
    /**
     * Show vehicle FPA details
     *
     * @param Vehicle $vehicle
     * @return array
     */
    public function show(
        ViewVehicleRequest $request,
        Vehicle $vehicle,
        RecentlyViewed $recentlyViewed,
        VehicleRepository $repository
    ) {
        $repository->trackView($vehicle);
        $recentlyViewed->add('vehicles', $vehicle->id);
        return [
            'data' => new VehicleResource($vehicle),
            'cross_sell' => [
                'name' => __('automotive.cross-sell.similar'),
                'items' => (new VehicleRepository())->similar($vehicle),
            ],
        ];
    }

    /**
     * Get list of recently viewed vehicles
     *
     * @param Vehicle $vehicle
     * @param Request $request
     * @return array
     */
    public function recentlyViewed(Vehicle $vehicle, Request $request)
    {
        $vehicleSlugs = $request->input('slugs') ?? [];

        return [
            'recently_viewed' => [
                'name' => __('automotive.recently_viewed'),
                'items' => (new VehicleRepository())->recentlyViewed($vehicle, $vehicleSlugs),
            ]
        ];
    }
}
