<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\SeoDefault;

class DealershipView extends JsonResource
{
    public static $wrap = '';
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load([
            'mediaUses.media',
        ]);

        return [
            'name' => $this->resource->name,
            'slug' => $this->resource->slug,
            'contact_no' => $this->resource->contact_no,
            'email' => $this->resource->email,
            'coordinates' => $this->resource->coordinates,
            'open_times' => $this->resource->open_times,
            'is_open' => $this->resource->is_open,
            'opens_at' => $this->resource->opens_at,
            'closes_at' => $this->resource->closes_at,
            'seo' => $this->fillSeo(),
            'address' => collect([
                $this->resource->address1,
                $this->resource->address2,
                $this->resource->city,
                $this->resource->county,
                $this->resource->postcode,
            ])->filter()->implode(', '),
            'images' => $this->resource->mediaUses->map(fn ($mediaUse) => [
                'src' => $mediaUse->getUrl('2560x650'),
                'alt' => $mediaUse->alt_text,
            ]),

        ];
    }

    private function fillSeo(): array
    {
        $seoData = $this->resource['seo'] ?? [];
        if (!empty($seoData['title']) && !empty($seoData['description'])) {
            return $seoData;
        }

        $default = SeoDefault::query()->where('section', 'dealership')->first();
        if (!$default) {
            return $seoData;
        }

        if (empty($seoData['title'])) {
            $seoData['title'] = $this->replaceSeoTags([
                '{{TITLE}}' => $this->resource->name,
                '{{SITE_NAME}}' => Settings::get('app-name'),

            ], $default->title ?? $this->resource->title);
        }

        if (empty($seoData['description'])) {
            $seoData['description'] = $this->replaceSeoTags([
                '{{TITLE}}' => $this->resource->name,
                '{{SITE_NAME}}' => Settings::get('app-name'),

            ], $default->description ?? '');
        }
        return $seoData;
    }

    private function replaceSeoTags(array $replacements, string $string): string
    {
        return str_replace(array_keys($replacements), $replacements, $string);
    }
}
