<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UiArticleCard extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $image = $this->resource->subContent
            ->where('slug', 'image')
            ->first()
            ->mediaUses
            ->first();
        return [
            'image' => $image ? [
                'src' => $image->getUrl('900x600'),
                'alt' => $image->alt_text,
            ] : null,
            'title' => $this->resource->subContent->where('slug', 'title')->first()->content,
            'label' => $this->resource->subContent->where('slug', 'label')->first()->content,
            'url' => $this->resource->subContent->where('slug', 'url')->first()->content ?? '#',
        ];
    }
}
