<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ValuationResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->resource->id,
            'make' => $this->resource->make,
            'model' => $this->resource->model,
            'derivative' => $this->resource->derivative,
            'fuelType' => $this->resource->fuel_type,
            'bodyType' => $this->resource->body_type,
            'retailPrice' => $this->resource->retail_price,
            'belowPrice' => $this->resource->below_price,
            'averagePrice' => $this->resource->average_price,
            'cleanPrice' => $this->resource->clean_price,
        ];
    }
}
