<?php

declare(strict_types=1);

use App\Http\Controllers\ConversionController;
use App\Http\Controllers\DealershipController;
use App\Http\Controllers\EnquiryController;
use App\Http\Controllers\FilterController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\OfferController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\ValuationController;
use App\Http\Controllers\VehicleController;
use App\Http\Middleware\PreventRequestsIfTenantSuspended;
use App\Http\Middleware\SeoRedirectCheckMiddleware;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use App\Middleware\InitializeTenancyByDomain;

/*
|--------------------------------------------------------------------------
| Tenant Routes
|--------------------------------------------------------------------------
|
| Here you can register the tenant routes for your application.
| These routes are loaded by the TenantRouteServiceProvider.
|
| Feel free to customize them however you want. Good luck!
|
*/

Route::middleware([
    'api',
    InitializeTenancyByDomain::class,
])->prefix('frontend/')->group(function (Router $router) {

    $router->get('/get-site', [SiteController::class, 'index'])->name('get-site');

    Route::middleware([
        PreventRequestsIfTenantSuspended::class,
        SeoRedirectCheckMiddleware::class,
    ])->group(function (Router $router) {
        $router->post('verify-access', [SiteController::class, 'checkAccess'])->name('check-site-access');
        $router->post('/newsletter', [NewsletterController::class, 'store'])->name('newsletter-signup');
        $router->post('/enquiries', [EnquiryController::class, 'store'])->name('enquiries.store');
        $router->get('/pages/{page}', [PageController::class, 'show'])->name('pages.show');

        $router->post('/find-vehicle', [FilterController::class, 'index'])->name('vehicles.index');
        $router->post('/find-vehicle/widget', [FilterController::class, 'widget'])->name('vehicles.widget');
        $router->get('/vehicles/{vehicle:slug}', [VehicleController::class, 'show'])->name('vehicles.show');
        $router->get('/recent-vehicles/{vehicle:slug?}', [VehicleController::class, 'recentlyViewed'])
            ->name('vehicles.recentlyViewed');

        $router->post('/valuations', [ValuationController::class, 'get'])->name('valuations.get');
        $router->get('/dealerships', [DealershipController::class, 'index'])->name('dealerships.index');
        $router->get('/dealerships/{dealership:slug}', [DealershipController::class, 'show'])->name('dealerships.show');

        $router->post('/offers', [OfferController::class, 'index'])->name('offers.index');
        $router->post('/offers/{make}', [OfferController::class, 'search'])->name('offers.search');
        $router->get('/offers/{offer:slug}', [OfferController::class, 'show'])->name('offers.show');

        $router->post('/conversion/track', [ConversionController::class, 'store'])->name('conversions.track');
    });
});
