<?php

namespace App\Http\Controllers;

use App\Http\Resources\DealershipList;
use App\Http\Resources\DealershipView;
use Mtc\MercuryDataModels\Dealership;

class DealershipController extends Controller
{
    public function index()
    {
        return new DealershipList(Dealership::query()->where('active', 1)->with(['mediaUses.media'])->get());
    }

    public function show(Dealership $dealership)
    {
        if (!$dealership->active) {
            return response('Not Found', 404);
        }
        return new DealershipView($dealership);
    }
}
