<?php

namespace App\Http\Requests;

use App\Tier;
use App\TierHelper;
use Illuminate\Foundation\Http\FormRequest;
use Mtc\VehicleValuation\Facades\Valuation;

class ValuationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return TierHelper::isAllowed(tenant('tier'), Tier::PRO->value)
            && Valuation::hasEnabledDriver();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'registration_number' => [
                'required',
                'alpha_num',
            ],
            'mileage' => [
                'required',
                'numeric',
                'min:0',
            ],
        ];
    }
}
