<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Log;

class ViewOfferRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        Log::debug('offer access check', [
            $this->input('a'),
            base64_encode($this->offer?->id . '-' . $this->offer?->slug),
            $this->offer,
        ]);
        return $this->public() || $this->withAccessKey();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            //
        ];
    }

    private function public(): bool
    {
        return $this->offer?->published ?? false;
    }

    private function withAccessKey(): bool
    {
        return $this->input('a') === base64_encode($this->offer?->id . '-' . $this->offer?->slug);
    }
}
